/*---------------------------------------------------------------------------+
| PMSPY profile open / save procedures
|
| Change History:
| ---------------
| $C1=1.11,06/26/89,jvk,creation
+---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------+
| Includes                                                                   |
+---------------------------------------------------------------------------*/
#include "pmspy.h"                      /* Resource symbolic identifiers*/

#include <ctype.h>

/*---------------------------------------------------------------------------+
| local variables                                                            |
+---------------------------------------------------------------------------*/

static CHAR          szFileName[FILEDLG_DRIVE_LENGTH + FILEDLG_PATH_LENGTH +
                                FILEDLG_FILE_LENGTH];

typedef enum {  kwError,                        /* Profile keywords */
                kwComment,

                kwINCLUDE,
                kwEXCLUDE,
                kwSPYON,
                kwLIST,
                kwLOG,
                kwMIN,
                kwX,
                kwY,
                kwCX,
                kwCY,
                kwCOLOR,
                kwDEFINE,
                kwGROUP,

                kwTOTAL

             } kwPROFILE;

typedef enum {  tokKW,                          /* line tokens */

                tokParm1,
                tokParm2,
                tokParm3,
                tokParm4,
                tokParm5,

                tokTOTAL,

                tokLAST = tokTOTAL - 1

             } tokPROFILE;

static PSZ NullString = "";

static WORD_LIST KeyWords[] = {
                                { &Strings[IDS_PRO_KW_COLOR],    kwCOLOR  },
                                { &Strings[IDS_PRO_KW_CX],       kwCX     },
                                { &Strings[IDS_PRO_KW_CY],       kwCY     },
                                { &Strings[IDS_PRO_KW_DEFINE],   kwDEFINE },
                                { &Strings[IDS_PRO_KW_EXCLUDE],  kwEXCLUDE},
                                { &Strings[IDS_PRO_KW_GROUP],    kwGROUP  },
                                { &Strings[IDS_PRO_KW_INCLUDE],  kwINCLUDE},
                                { &Strings[IDS_PRO_KW_LIST],     kwLIST   },
                                { &Strings[IDS_PRO_KW_LOG],      kwLOG    },
                                { &Strings[IDS_PRO_KW_MIN],      kwMIN    },
                                { &Strings[IDS_PRO_KW_SPYON],    kwSPYON  },
                                { &Strings[IDS_PRO_KW_X],        kwX      },
                                { &Strings[IDS_PRO_KW_Y],        kwY      },
                                { &Strings[IDS_PRO_KW_COMMENT1], kwComment},
                                { &Strings[IDS_PRO_KW_COMMENT2], kwComment},
                                { &NullString,                   kwComment},

                                { NULL,                          kwError  }
                              };

static WORD_LIST SpyValues[] = {

                                { &Strings[IDS_PRO_VALUE_QUEUE],    0},
                                { &Strings[IDS_PRO_VALUE_WINDOW],   1},
                                { NULL,                             2}
                              };

static WORD_LIST ListValues[] = {

                                { &Strings[IDS_PRO_VALUE_FREEZE],   0},
                                { &Strings[IDS_PRO_VALUE_THAWED],   1},
                                { NULL,                             2}
                              };

static PSZ Tokens[tokTOTAL];

#define NoGroupID   0xFFFF

static MSG_ITEM proMsg = { Single,                      /* Msg type          */
                           NULL,                        /* specific Msg      */
                           NULL,                        /* used if "range"   */
                           NULL,                        /* MSG description   */
                           Standard,                    /* formatting style  */
                           TRUE,                        /* include msg?      */
                           Yes,                         /* what to do if not included */
                           Color_Default,               /* @C1A logical FG color to DRAW */
                           NoGroupID,                   /* GROUP this msg defined in */
                           FALSE                        /* processed during SAVE yet? */
                         };

static GRP_ITEM proGrp = {
                           NoGroupID,                   /* This GROUP's ID */
                           NULL,                        /* Group's Description */
                           TRUE,                        /* include GROUP?*/
                           Color_Default,               /* logical FG color to DRAW */
                         };

/*---------------------------------------------------------------------------+
| Parse Color Index
| INPUT  : - pszToken    : token to use for <color>
|          - theDefault  : default color if no value specifed
|
| OUTPUT : Color_Error if error detected
|          otherwise, valid ColorX value (Color1..Color8) -or- 'default'
|
+---------------------------------------------------------------------------*/

static MSG_COLOR ParseColorIndex( PSZ       pszToken,
                                  MSG_COLOR theDefault)

{
  register MSG_COLOR logColor = Color_Error;     /* start a pessimist... */


  do
  {
    if ( pszToken == NullString )
    {
      logColor = theDefault;

      break;
    }

    logColor = (MSG_COLOR) atoi(pszToken);

    if ( (logColor < Color_First) || (logColor > Color_Last) )
      break;             /* ignore if bad color index */

    logColor--;          /* convert from 1-origin to 0-origin */

  } while( TRUE == FALSE );

  return( logColor );
}

/*---------------------------------------------------------------------------
|
| Parse Message command
|
| Format : Include/Exclude  = <id>
|
|                   <id>    = specific message name (like WM_USER, etc)
|                           = specific group   name (like XXXX )
|                           = All
|
| Notes  : - the 'verb' has already been parsed off for us...
|
| INPUT  : - input buffer ready for next STRTOK usage
|          - isInclude  : T=Include, F=Exclude
|
| OUTPUT : TRUE if succesfull
|
+---------------------------------------------------------------------------*/

static BOOL ParseMsgCmd(BOOL Include)
{
           BOOL      isOK = FALSE;              /* start as a pessimist */
  register PMSG_ITEM pMsg;
  register PGRP_ITEM pGrp;

  do
  {
    /* process the <id> value */

    if ( Tokens[tokParm1] == NullString )
      break;

    /* check the <id> value */

    if (strcmpi(Tokens[tokParm1], Strings[IDS_PRO_VALUE_ALL]) == 0)
    {
      IncludeAllMsgs( pSpyData, Include, Color_Asis );
      isOK = TRUE;
    }
    else
    {
      /* check if a specific message */

      if ( (pMsg = FindMsgName(pSpyData, Tokens[tokParm1])) != NULL )
      {
        IncludeMsg(pSpyData, pMsg->Msg, Include, Color_Asis);
        isOK = TRUE;
        break;
      }

      /* check if a specific group */

      if ( (pGrp = FindGroupName(pSpyData, Tokens[tokParm1])) != NULL )
      {
        /* process all messages in the GROUP */

        IncludeGroup(pSpyData, pGrp, Include, Color_Asis);

        isOK = TRUE;
        break;
      }

    } /* endif */

  } while( TRUE == FALSE );

  return( isOK );
}

/*---------------------------------------------------------------------------+
| Open the Profile                                                           |
| INPUT  : - hwnd   : window handle of the client                            |
|          - szFile : filename                                               |
|                     ===> if NULL, open the 'standard' PROFILE              |
| OUTPUT : TRUE if succesfull                                                |
+---------------------------------------------------------------------------*/

BOOL OpenProfile(HWND hwndCur,
                 HWND hwndFrame,
                 PSPY_DATA pSpy,
                 PSZ szFile)
{
  static PDTR_DATA  defProfile = {
                                   NULL,         /* resource location (.EXE) */
                                   IDT_HELP,     /* resource TYPE */
                                   IDT_DEFAULTS  /* resource ID */
                                 };
  SWP             pos;
  BOOL            bMin = FALSE;

  FILE            *pProFile = NULL;
  CHAR            szLine[256];
  PSZ             psz;
  BOOL            stop;
  register USHORT logColor, i;

  /* Reset default items.... */

  WinQueryWindowPos(hwndFrame, &pos);   /* default to "current" position */

  proGrp.ClrFG   =
  proMsg.ClrFG   = Color_Default;

  proGrp.GroupID =
  proMsg.GroupID = NoGroupID;

  proGrp.Include =
  proMsg.Include = TRUE;

  /* Open the specified PROFILE */

  if ( szFile == NULL )
  {
    if ( OpenPDTR(&defProfile) == NULL)
    return(FALSE);
  }
  else
  {
    if ( (pProFile = fopen(szFile, "r")) == NULL)
      return(FALSE);
  }

  /* Process each line until EOF... */

  while ( (szFile == NULL ? GetsPDTR(&defProfile, szLine, sizeof(szLine))
                          : fgets(szLine, sizeof(szLine), pProFile)) != NULL)
  {
    /* replace NEWLINE with a NULL */

    if (psz=strchr(szLine,'\n'))
      *psz = NULL;

    /* Tokenize all parts of this line */

    for(/* Init */ i = 0;
        /* Term */ i <= tokLAST;
        /* Iter */ i++)
    {
      Tokens[i] = strtok(i == 0 ? szLine : NULL, Strings[IDS_PRO_DELIM]);

      if (Tokens[i] == NULL)        /* Insure valid pointer */
        Tokens[i] = NullString;

    }

    /* Process this line's keyword */

    switch( FindWordInList(Tokens[tokKW], &KeyWords[0]) )
    {
     case kwINCLUDE:

          ParseMsgCmd(TRUE);
          break;

     case kwEXCLUDE:

          ParseMsgCmd(FALSE);
          break;

     case kwSPYON:

          switch( FindWordInList(Tokens[tokParm1], &SpyValues[0]) )
          {
            case 0:  WinSendMsg(hwndCur, WM_COMMAND, MPFROMSHORT(IDD_QUE), (MPARAM)NULL);
                     break;

            case 1:  WinSendMsg(hwndCur, WM_COMMAND, MPFROMSHORT(IDD_WND), (MPARAM)NULL);
            default: break;

          }
          break;

     case kwLIST:
          switch( FindWordInList(Tokens[tokParm1], &ListValues[0]) )
          {
            case 0:  WinSendMsg(hwndCur, WM_COMMAND, MPFROMSHORT(ID_O_FREEZE), (MPARAM)NULL);
                     break;

            case 1:  WinSendMsg(hwndCur, WM_COMMAND, MPFROMSHORT(ID_O_THAW), (MPARAM)NULL);
            default: break;

          }
          break;

     case kwLOG:

          if (Tokens[tokParm1] != NullString)
          {
            _splitpath(psz, szLogDrive, szLogPath, szLogFile, szLogPattern);
            strcpy(szFileName, szLogDrive);

            if (szLogPath[0] != '\0' && szLogPath[1] != '\0')
            {
              strcat(szFileName, "\\");
              strcat(szFileName, szLogPath);
            }

            strcat(szFileName, szLogFile);
            strcat(szFileName, szLogPattern);

            strcpy(szLogPattern, "*.LOG");

            stop = strcmpi(Tokens[tokParm2], Strings[IDS_PRO_VALUE_FREEZE]) == 0
                   ? TRUE : FALSE;

            if (pLogFile)
              fclose(pLogFile);

            pLogFile = fopen(szFileName, "w");

            if (pLogFile)
              bCurrentlyLogging = stop;
          }
          break;

     case kwMIN:

          bMin = TRUE;
          break;

     case kwX:
          pos.x  = atoi(Tokens[tokParm1]);
          break;


     case kwY:
          pos.y  = atoi(Tokens[tokParm1]);
          break;

     case kwCX:
          pos.cx = atoi(Tokens[tokParm1]);
          break;

     case kwCY:
          pos.cy = atoi(Tokens[tokParm1]);
          break;

     case kwCOLOR:
          /* process: Color <index> <value> */

          do
          {
            if ( (logColor=ParseColorIndex(Tokens[tokParm1],
                                           Color_Error)) == Color_Error )
              break;             /* ignore if bad <color index> */

            if ( Tokens[tokParm2] == NullString )
              break;             /* ignore if bad <value> */

            /* look up PROFILE color name in table */

            for(i = 0;
                ( (ExternalColorTranslation[i].pszClrName != NULL) &&
                  (strcmpi(ExternalColorTranslation[i].pszClrName, Tokens[tokParm2]) != 0));
                i++);

            if ( ExternalColorTranslation[i].pszClrName == NULL)
              break;

            pSpyData->LogicalColorTranslation[logColor].iExtColor = i;

          } while(TRUE == FALSE);
          break;

     case kwDEFINE:

          /* process: Define <msg desc> <msg no> [<color index>] */

          do
          {

            /* Process <msg desc> */

            if (Tokens[tokParm1] == NullString)
              break;

            /* Process <msg no> */

            if ( !ConvertToNumber(Tokens[tokParm2], &proMsg.Msg, 0, 0xFFFF) )
              break;

            /* Process <color index> (optional) */

            if ( (proMsg.ClrFG=ParseColorIndex(Tokens[tokParm3],
                                               proGrp.ClrFG)) == Color_Error )
              break;             /* ignore if bad <color index> */

            /* Add new message */

            proMsg.pDesc = AllocateMemory( strlen(Tokens[tokParm1]) + 1);
            strcpy(proMsg.pDesc, Tokens[tokParm1]);

            /* "Special" messages that MUST be 'eaten' (trust me!) */

            switch( proMsg.Msg )
            {
              case WM_HITTEST:
              case WM_CONTROLPOINTER:
              case WM_MOUSEMOVE:        proMsg.NoInclude = No_EatMsg;
                                        break;

              default:                  proMsg.NoInclude = No_PassOn;
                                        break;
            }

            AddMsg(pSpy, &proMsg);

          } while(TRUE == FALSE);
          break;

     case kwGROUP:

          /* process: Group <Group desc> [<color index>] */

          do
          {

            /* Process <Group desc> */

            if (Tokens[tokParm1] == NullString)
              break;

            /* Process <color index> (optional) */

            if ( (proGrp.ClrFG=ParseColorIndex(Tokens[tokParm2],
                                               Color_Default)) == Color_Error )
              break;             /* ignore if bad <color index> */

            /* Add new GROUP */

            proGrp.pDesc = AllocateMemory( strlen(Tokens[tokParm1]) + 1);
            strcpy(proGrp.pDesc, Tokens[tokParm1]);

            proMsg.GroupID = AddGroup(pSpy, &proGrp);  /* all MSGS to this GROUP now... */

          } while(TRUE == FALSE);
          break;

     case kwComment:
          break;

     default:
          break;
    } /* switch on KW values */
  } /* endwhile */

  /* Close the source of the PROFILE data */

  if (szFile == NULL)
    ClosePDTR(&defProfile);
  else
    fclose(pProFile);

  WinSetWindowPos(hwndFrame, HWND_TOP, pos.x, pos.y, pos.cx, pos.cy,
                  SWP_MOVE | SWP_SIZE | SWP_ZORDER | SWP_ACTIVATE | SWP_SHOW);

  if (bMin)
    WinSetWindowPos(hwndFrame, NULL, pos.x, pos.y, pos.cx, pos.cy, SWP_MINIMIZE);

  return(TRUE);
}

/*---------------------------------------------------------------------------+
| Save the Profile                                                           |
+---------------------------------------------------------------------------*/

BOOL SaveProfile(HWND      hwnd,
                 PSPY_DATA pSpy,
                 PSZ       szFile)
{
  FILE  *pProFile = NULL;
  SWP   swp;

  register USHORT     i;
  register PMSG_ITEM  pMsg;
  register PGRP_ITEM  pGrp;

  if ( (pProFile = fopen(szFile, "w")) == NULL)
    return(FALSE);

  WinQueryWindowPos(hwndFrame, &swp);

  fprintf(pProFile, Strings[IDS_PRO_HEADER],
          VERSION/100, (VERSION - 100*(VERSION/100)), "\n");

  fprintf(pProFile, Strings[IDS_PRO_POS_HEADER],"\n", "\n\n");

  fprintf(pProFile, Strings[IDS_PRO_POS_FMT_X],  Strings[IDS_PRO_KW_X], swp.x,"\n");

  fprintf(pProFile, Strings[IDS_PRO_POS_FMT_Y],  Strings[IDS_PRO_KW_Y], swp.y,"\n");

  fprintf(pProFile, Strings[IDS_PRO_POS_FMT_CX], Strings[IDS_PRO_KW_CX],swp.cx,"\n");

  fprintf(pProFile, Strings[IDS_PRO_POS_FMT_CY], Strings[IDS_PRO_KW_CY],swp.cy,"\n");

  fprintf(pProFile, Strings[IDS_PRO_SET_HEADER],"\n", "\n\n");

  fprintf(pProFile, Strings[IDS_PRO_SET_FMT_SPY],
                    Strings[IDS_PRO_KW_SPYON],
                    SpyQueryTargetIsWindow(SpyInstance)
                      ? Strings[IDS_PRO_VALUE_WINDOW]
                      : Strings[IDS_PRO_VALUE_QUEUE],
                    "\n");

  fprintf(pProFile, Strings[IDS_PRO_SET_FMT_LIST],
                    Strings[IDS_PRO_KW_LIST],
                    bSuspendMsgDisplay ? Strings[IDS_PRO_VALUE_FREEZE]
                                       : Strings[IDS_PRO_VALUE_THAWED],
                    "\n");

  if (pLogFile)
  {
    fprintf(pProFile, Strings[IDS_PRO_LOG_HEADER], "\n", "\n");

    fprintf(pProFile, Strings[IDS_PRO_LOG_FMT_FILE],
                    Strings[IDS_PRO_KW_LOG],
                      szLogFile,
                      bCurrentlyLogging ? ""
                                        : Strings[IDS_PRO_VALUE_STOPPED],
                      "\n");
  }

  /* Save the COLOR settings: Color <i> <color name> */

  fprintf(pProFile, Strings[IDS_PRO_COLOR_HEADER], "\n", "\n\n");

  for( /* Initialize */  i = 0;              /* start @ first */
       /* Terminate  */  i < Color_Total;    /* stop at End-Of-Table */
       /* Iterate    */  i++                 /* try the next */
     )
  {
    fprintf(pProFile,
            Strings[IDS_PRO_COLOR_FMT],
            Strings[IDS_PRO_KW_COLOR],
            i + 1,                    /* externally, it's ONE origin... */
   ExternalColorTranslation[pSpy->LogicalColorTranslation[i].iExtColor].pszClrName,
            "\n");
  }

  /* Save each GROUP and MSG */

  fprintf(pProFile, Strings[IDS_PRO_DEFINE_HEADER], "\n", "\n\n");

  for(/* Initialize */ pGrp = ProcessFirstGroup(pSpy); /* @ first GROUP */
      /* Terminate  */ pGrp != NULL;                   /* @ end of list */
      /* Iterate    */ pGrp = ProcessNextGroup(pSpy)   /* Try next GROUP */
     )
  {
    fprintf(pProFile,
            Strings[IDS_PRO_GROUP_FMT],
            "\n",
            Strings[IDS_PRO_KW_GROUP],
            pGrp->pDesc,
            pGrp->ClrFG + 1,
            "\n\n");

    for( /* Initialize */  pMsg = ProcessFirstMsgInGroup(pSpy,pGrp->GroupID);/* start @ first MSG */
         /* Terminate  */  pMsg != NULL;                /* stop at End-Of-Table */
         /* Iterate    */  pMsg = ProcessNextMsgInGroup(pSpy)  /* try the next MSG */
       )
    {
      if ( pMsg->ClrFG == pGrp->ClrFG )                 /* MSG use same color? */
        fprintf(pProFile,
                Strings[IDS_PRO_DEFINE_FMT],
                Strings[IDS_PRO_KW_DEFINE],
                pMsg->pDesc,
                pMsg->Msg,
                "\n");
      else
        fprintf(pProFile,
                Strings[IDS_PRO_DEFINE_FMT_COLOR],
                Strings[IDS_PRO_KW_DEFINE],
                pMsg->pDesc,
                pMsg->Msg,
                pMsg->ClrFG + 1,
                "\n");
    }
  }

  /* Save the FILTER settings */

  fprintf(pProFile, Strings[IDS_PRO_FIL_HEADER],  "\n", "\n\n");

  /* First, reset all the MSG 'SaveProcessed' flags */

  for( /* Initialize */  pMsg = ProcessFirstMsg(pSpy);/* start @ first MSG */
       /* Terminate  */  pMsg != NULL;                /* stop at End-Of-Table */
       /* Iterate    */  pMsg = ProcessNextMsg(pSpy)  /* try the next MSG */
     )
    pMsg->SaveProcessed = FALSE;

  /* Second, process each GROUP */

  for(/* Initialize */ pGrp = ProcessFirstGroup(pSpy); /* @ first GROUP */
      /* Terminate  */ pGrp != NULL;                   /* @ end of list */
      /* Iterate    */ pGrp = ProcessNextGroup(pSpy)   /* Try next GROUP */
     )
  {
    fprintf(pProFile,
            Strings[IDS_PRO_FILTER_FMT],
            pGrp->Include ? Strings[IDS_PRO_KW_INCLUDE]
                          : Strings[IDS_PRO_KW_EXCLUDE],
            pGrp->pDesc,
            "\n");

    /* Mark each MSG in this GROUP as processed if same Include state... */

    for( /* Initialize */ pMsg = ProcessFirstMsgInGroup(pSpy,pGrp->GroupID); /* start @ first MSG */
         /* Terminate  */ pMsg != NULL;                          /* stop at End-Of-Table */
         /* Iterate    */ pMsg = ProcessNextMsgInGroup(pSpy) /* try the next MSG */
       )
    {
      if (pMsg->Include == pGrp->Include)
        pMsg->SaveProcessed = TRUE;
    }
  }

  fputc('\n', pProFile);

  /* Third, process each MSG looking for ones not processed */

  for( /* Initialize */  pMsg = ProcessFirstMsg(pSpy);/* start @ first MSG */
       /* Terminate  */  pMsg != NULL;                /* stop at End-Of-Table */
       /* Iterate    */  pMsg = ProcessNextMsg(pSpy)  /* try the next MSG */
     )
  {
    /* Skip undefined "User Defined" messages */

    if (!pMsg->SaveProcessed)
      fprintf(pProFile,
              Strings[IDS_PRO_FILTER_FMT],
              pMsg->Include ? Strings[IDS_PRO_KW_INCLUDE]
                            : Strings[IDS_PRO_KW_EXCLUDE],
              pMsg->pDesc,
              "\n");
  }

  /* end of SAVE stuff */

  fprintf(pProFile, Strings[IDS_PRO_END], "\n", "\n");

  fclose(pProFile);

  return(TRUE);
}
